// ProteusXESTerminalDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ProteusXESTerminal.h"
#include "ProteusXESTerminalDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define COM_USB			1
#define COM_TCPIP		2
#define COM_SERIAL		3
#define COMND_BUF_LEN	255
#define REPLY_BUF_LEN	6000

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProteusXESTerminalDlg dialog

CProteusXESTerminalDlg::CProteusXESTerminalDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CProteusXESTerminalDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProteusXESTerminalDlg)
	m_strCommand = _T("");
	m_nComPort = 1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CProteusXESTerminalDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProteusXESTerminalDlg)
	DDX_Control(pDX, IDC_RADIO_USB, m_RBtn_USB);
	DDX_Control(pDX, IDC_RADIO_TCPIP, m_RBtn_TCPIP);
	DDX_Control(pDX, IDC_RADIO_SERIAL, m_RBtn_Serial);
	DDX_Control(pDX, IDC_LIST_REPLY, m_ListBox_Reply);
	DDX_Text(pDX, IDC_EDIT_COMMAND, m_strCommand);
	DDX_Control(pDX, IDC_IPADDRESS, m_Ctrl_IPAdd);
	DDX_Text(pDX, IDC_EDIT_COM_PORT, m_nComPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CProteusXESTerminalDlg, CDialog)
	//{{AFX_MSG_MAP(CProteusXESTerminalDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, OnButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_SEND, OnButtonSend)
	ON_BN_CLICKED(IDC_RADIO_USB, OnRadioUsb)
	ON_BN_CLICKED(IDC_RADIO_TCPIP, OnRadioTcpip)
	ON_BN_CLICKED(IDC_RADIO_SERIAL, OnRadioSerial)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProteusXESTerminalDlg message handlers

BOOL CProteusXESTerminalDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Select USB by default
	m_RBtn_USB.SetCheck(BST_CHECKED);
	bConnected = FALSE;
	lHandle = -1;
	nComType = COM_USB;
	m_Ctrl_IPAdd.SetAddress(10, 10, 6, 101);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CProteusXESTerminalDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CProteusXESTerminalDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CProteusXESTerminalDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CProteusXESTerminalDlg::OnButtonConnect() 
{
	CString strComType = _T("");

	if (bConnected)
	{
		UpdateData(TRUE);
		m_ListBox_Reply.AddString("Already connected");
		UpdateData(FALSE);
		m_ListBox_Reply.SetCaretIndex(m_ListBox_Reply.GetCount()-1);
		return;
	}

	if (nComType == COM_USB)
	{
		// connect using USB
		lHandle = fnProteusComOpen(COM_USB, 1, NULL);
		strComType = "USB";
	}
	else if (nComType == COM_TCPIP)
	{
		CString strIPAddress;
		BYTE nField0, nField1, nField2, nField3;

		m_Ctrl_IPAdd.GetAddress(nField0, nField1, nField2, nField3);
		strIPAddress.Format(_T("%d.%d.%d.%d"), nField0, nField1, nField2, nField3);
		lHandle = fnProteusComOpen(COM_TCPIP, 0, (char*)(LPCSTR)strIPAddress);
		strComType = "TCPIP";
	}
	else if (nComType == COM_SERIAL)
	{
		// connect using serial port
		CString strPortNo;
		UpdateData(TRUE);
		strPortNo.Format("Com%d", m_nComPort);
		lHandle = fnProteusComOpen(COM_SERIAL, 1, (char*)(LPCSTR)strPortNo);
		strComType = "RS232";
	}

	if (lHandle >0)
	{
		bConnected = TRUE;
		UpdateData(TRUE);
		m_ListBox_Reply.AddString("Connected to the device using "+strComType);
		UpdateData(FALSE);
		m_ListBox_Reply.SetCaretIndex(m_ListBox_Reply.GetCount()-1);
	}
	else
	{
		UpdateData(TRUE);
		m_ListBox_Reply.AddString("Cannot connect to the device using "+strComType);
		UpdateData(FALSE);
		m_ListBox_Reply.SetCaretIndex(m_ListBox_Reply.GetCount()-1);
	}

}

void CProteusXESTerminalDlg::OnButtonDisconnect() 
{
	BOOL bResult = FALSE;

	if (!bConnected)
	{
		MessageBox("Not connected.");
		return;
	}

	bResult = Disconnect();

	if (bResult)
	{
		UpdateData(TRUE);
		m_ListBox_Reply.AddString("Disconnected the device.\n");
		UpdateData(FALSE);
		bConnected = FALSE;
		m_ListBox_Reply.SetCaretIndex(m_ListBox_Reply.GetCount()-1);
	}
}

void CProteusXESTerminalDlg::OnButtonSend() 
{
	CString strReply(_T(""));
	int i;
	BOOL bResult = FALSE;
	char	*pCmdBuffer, *pResponseBuffer;
	int nLength;

	pCmdBuffer = (char*)calloc(1, COMND_BUF_LEN);
	pResponseBuffer = (char*)calloc(1, REPLY_BUF_LEN);

	if (pCmdBuffer == NULL || pResponseBuffer == NULL)
	{
		MessageBox("Can't allocate memory");
		free(pCmdBuffer);
		free(pResponseBuffer);
		return;
	}

	UpdateData(TRUE);
	strcpy(pCmdBuffer, m_strCommand);

	nLength = m_strCommand.GetLength();
	*(pCmdBuffer+nLength) ='\r'; //USB need this CR to process the command

	if (bConnected)
	{
		bResult = fnProteusComSendRecv(nComType, lHandle, pCmdBuffer, pResponseBuffer);

		if (bResult)
		{	
			for (i = 0; i < REPLY_BUF_LEN && *(pResponseBuffer+i) != '\0'; i++)
			{
				if (*(pResponseBuffer+i) == 0x04) // EOT - End of Transmission
					break;

				if (*(pResponseBuffer+i) == '\r') // character return
				{					
					UpdateData(TRUE);
					m_ListBox_Reply.AddString(strReply);
					UpdateData(FALSE);
					strReply = _T("");
				}
				else
					strReply += *(pResponseBuffer+i);
			}
			
		}
	}
	else
		MessageBox("Not connected!");
	
	// Clear the command edit box
	UpdateData(TRUE);
	m_strCommand = _T("");
	UpdateData(FALSE);

	m_ListBox_Reply.SetCaretIndex(m_ListBox_Reply.GetCount()-1);

	free(pCmdBuffer);
	free(pResponseBuffer);
}

void CProteusXESTerminalDlg::OnOK() 
{
	Disconnect();
	CDialog::OnOK();
}

BOOL CProteusXESTerminalDlg::Disconnect()
{
	BOOL bResult = FALSE;

	if(bConnected)
		bResult= fnProteusComClose(nComType, lHandle);

	return bResult;
}

void CProteusXESTerminalDlg::OnRadioUsb() 
{
	if (bConnected)
	{
		if (nComType != COM_USB)
		{
			if (MessageBox("Need to disconnect the device currently using another method. Continue?", NULL, MB_YESNO) == IDYES)
			{
				OnButtonDisconnect();
			}
			else
			{
				m_RBtn_USB.SetCheck(FALSE);
				if (nComType  == COM_TCPIP)
					m_RBtn_TCPIP.SetCheck(TRUE);
				else if (nComType  == COM_SERIAL)
					m_RBtn_Serial.SetCheck(TRUE);
				return;
			}			
		}
	}

	nComType = COM_USB;
}

void CProteusXESTerminalDlg::OnRadioTcpip() 
{
	if (bConnected)
	{
		if (nComType != COM_TCPIP)
		{
			if (MessageBox("Need to disconnect the device currently using another method. Continue?", NULL, MB_YESNO) == IDYES)
			{
				OnButtonDisconnect();
			}
			else
			{
				m_RBtn_TCPIP.SetCheck(FALSE);
				if (nComType  == COM_USB)
					m_RBtn_USB.SetCheck(TRUE);
				else if (nComType  == COM_SERIAL)
					m_RBtn_Serial.SetCheck(TRUE);
				return;
			}
		}
	}

	nComType = COM_TCPIP;	
}

void CProteusXESTerminalDlg::OnRadioSerial() 
{
	if (bConnected)
	{
		if (nComType != COM_SERIAL)
		{
			if (MessageBox("Need to disconnect the device currently using another method. Continue?", NULL, MB_YESNO) == IDYES)
			{
				OnButtonDisconnect();
			}
			else
			{
				m_RBtn_Serial.SetCheck(FALSE);
				if (nComType  == COM_USB)
					m_RBtn_USB.SetCheck(TRUE);
				else if (nComType  == COM_TCPIP)
					m_RBtn_TCPIP.SetCheck(TRUE);
				return;
			}		
		}
	}

	nComType = COM_SERIAL;	
}
